local ROTATION_SPEED=1.0
local SCALE_BASE=0.6
local SCALE_AMP=0.3
local SCALE_SPEED=3.33
local logicrunchlogo5={}
local logicrunchlogo5={image=nil,rotation=0,rotationSpeed=ROTATION_SPEED,scaleBase=SCALE_BASE,scaleAmp=SCALE_AMP,scaleSpeed=SCALE_SPEED,x=0,y=0,width=0,height=0,visible=false,initialTimeOffset=math.pi/2,alpha=1,elapsedTime=0,currentScale=SCALE_BASE}
function logicrunchlogo5.load()
logicrunchlogo5.image=love.graphics.newImage("logicrunchlogo5.png")
logicrunchlogo5.width,logicrunchlogo5.height=logicrunchlogo5.image:getWidth(),logicrunchlogo5.image:getHeight()
logicrunchlogo5.x,logicrunchlogo5.y=1920/2,1080/2-50
logicrunchlogo5.activate()
end
function logicrunchlogo5.activate()
logicrunchlogo5.visible=true
logicrunchlogo5.elapsedTime=0
logicrunchlogo5.alpha=1
logicrunchlogo5.rotation=0
logicrunchlogo5.currentScale=logicrunchlogo5.scaleBase
end
function logicrunchlogo5.update(dt)
if logicrunchlogo5.visible then
logicrunchlogo5.elapsedTime=logicrunchlogo5.elapsedTime+dt
logicrunchlogo5.rotation=logicrunchlogo5.rotation+logicrunchlogo5.rotationSpeed*dt
local t=(logicrunchlogo5.elapsedTime*logicrunchlogo5.scaleSpeed)+logicrunchlogo5.initialTimeOffset
logicrunchlogo5.currentScale=logicrunchlogo5.scaleBase+logicrunchlogo5.scaleAmp*math.sin(t)
local fadeStart=29.16
local fadeDuration=1.19
if logicrunchlogo5.elapsedTime>=fadeStart and logicrunchlogo5.elapsedTime<=fadeStart+fadeDuration then
logicrunchlogo5.alpha=1-((logicrunchlogo5.elapsedTime-fadeStart)/fadeDuration)
elseif logicrunchlogo5.elapsedTime>fadeStart+fadeDuration then
logicrunchlogo5.alpha=0
else
logicrunchlogo5.alpha=1
end end end
function logicrunchlogo5.draw()
if logicrunchlogo5.visible then
love.graphics.push()
love.graphics.translate(logicrunchlogo5.x,logicrunchlogo5.y)
love.graphics.rotate(logicrunchlogo5.rotation or 0)
love.graphics.scale(logicrunchlogo5.currentScale or 1,logicrunchlogo5.currentScale or 1)
love.graphics.setColor(1,1,1,logicrunchlogo5.alpha)
love.graphics.draw(logicrunchlogo5.image,-logicrunchlogo5.width/2,-logicrunchlogo5.height/2)
love.graphics.pop()
end end
return logicrunchlogo5
